import { a6d28777ab56c8416 } from "./internal/aa89649a981b0bfc2/a6d28777ab56c8416";
import { StarPrinter } from "./StarPrinter";
export class StarPrinterFactory {
    _starXpandCommandParserWorker = undefined;
    get starXpandCommandParserWorker() {
        if (!this._starXpandCommandParserWorker) {
            this._starXpandCommandParserWorker = new Worker(new URL("./internal/aedb43fd9d6e8cf4b.js", import.meta.url));
        }
        return this._starXpandCommandParserWorker;
    }
    constructor() {
        a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createInstanceCreatedString("StarPrinterFactory"));
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _ = this.starXpandCommandParserWorker;
        console.log("StarPrinterFactory instance created");
    }
    createStarPrinter(connectionSettings) {
        //disposeと同時に呼ばれるとWorkerのユーザ数判定が狂う可能性があるため、同期メソッドにしておくこと!
        return new StarPrinter(connectionSettings, this.starXpandCommandParserWorker);
    }
    dispose() {
        //createStarPrinterと同時に呼ばれるとWorkerのユーザ数判定が狂う可能性があるため、同期メソッドにしておくこと!
        const workerTaskID = Math.floor(Math.random() * 1000000); // 一意なIDを生成
        this.starXpandCommandParserWorker.postMessage({
            id: workerTaskID,
            type: "decrementUserNumber",
        });
    }
}
